import isEmpty from 'lodash/isEmpty';

import {
    IHotelsSearchFormErrors,
    IHotelsSearchFormPointField,
    IHotelsSearchFormValues,
    THotelsSearchFormDateField,
} from 'projects/hotels/components/SearchForm/types';
import {THotelSlug} from 'types/hotels/hotel/IHotel';
import {ESearchFormFieldName} from 'components/SearchForm/types';

import {getSearchUrl} from 'projects/hotels/utilities/urls/getSearchUrl';

import useImmutableCallback from 'hooks/useImmutableCallback';

export interface ISubmitArgs {
    handleTrySubmit(): void;
    formErrors: IHotelsSearchFormErrors;
    setHasSubmitFailed(val: boolean): void;
}

export default function useHandleSubmit({
    toField,
    startDateField,
    endDateField,
    adultsField,
    childrenAgesField,
    activeHotelSlug,
    queryParams,
    onSubmit,
}: {
    toField: IHotelsSearchFormPointField;
    startDateField: THotelsSearchFormDateField;
    endDateField: THotelsSearchFormDateField;
    adultsField: number;
    childrenAgesField: number[];
    activeHotelSlug?: THotelSlug;
    queryParams?: Record<string, string>;
    onSubmit?(params: {searchLink: string}): void;
}): (args: ISubmitArgs) => void {
    return useImmutableCallback(
        ({handleTrySubmit, formErrors, setHasSubmitFailed}) => {
            handleTrySubmit();

            if (isEmpty(formErrors)) {
                const formValues: IHotelsSearchFormValues = {
                    [ESearchFormFieldName.TO]: toField,
                    [ESearchFormFieldName.START_DATE]: startDateField,
                    [ESearchFormFieldName.END_DATE]: endDateField,
                    adults: adultsField,
                    childrenAges: childrenAgesField,
                };

                const searchLink = getSearchUrl({
                    activeHotelSlug,
                    searchFormFieldsValues: formValues,
                    queryParams,
                });

                console.log('url: ', searchLink);

                onSubmit?.({searchLink});
                window.open(
                    `https://travel.yandex.ru${searchLink}`,
                    '_blank',
                    'noopener,noreferrer',
                );
            } else {
                setHasSubmitFailed(true);
            }
        },
    );
}
