import {
    IHotelsSearchFormErrors,
    IHotelsSearchFormPointField,
    IHotelsSearchFormValues,
} from 'projects/hotels/components/SearchForm/types';

import * as i18nBlock from 'i18n/hotels-search-form';

const isEmptyDirectionValue = ({
    inputValue,
}: IHotelsSearchFormPointField): boolean => inputValue === '';

const isEmptySelectedValue = ({
    selectedValue,
}: IHotelsSearchFormPointField): boolean => selectedValue === false;

export function validatePoint(
    fieldsValues: IHotelsSearchFormValues,
): IHotelsSearchFormErrors {
    const {to} = fieldsValues;
    const errors: IHotelsSearchFormErrors = {};

    if (to !== undefined && isEmptySelectedValue(to)) {
        errors.to = [
            i18nBlock.hotelsSearchFormDotValidateDotNeedSelectToField(),
        ];
    }

    if (to !== undefined && isEmptyDirectionValue(to)) {
        errors.to = [i18nBlock.hotelsSearchFormDotValidateDotToFieldRequired()];
    }

    return errors;
}
