import {ActionType, createAction} from 'typesafe-actions';

import {
    IHotelsSearchFormPointField,
    THotelsSearchFormDateField,
} from 'projects/hotels/components/SearchForm/types';

export const setHotelsSearchFormToFieldAction = createAction(
    'HOTELS.SEARCH_FORM.SET_TO',
)<IHotelsSearchFormPointField>();
export const setHotelsSearchFormStartDateFieldAction = createAction(
    'HOTELS.SEARCH_FORM.SET_START_DATE',
)<THotelsSearchFormDateField>();
export const setHotelsSearchFormEndDateFieldAction = createAction(
    'HOTELS.SEARCH_FORM.SET_END_DATE',
)<THotelsSearchFormDateField>();
export const setHotelsSearchFormAdultsFieldAction = createAction(
    'HOTELS.SEARCH_FORM.SET_ADULTS',
)<number>();
export const setHotelsSearchFormChildrenAgesFieldAction = createAction(
    'HOTELS.SEARCH_FORM.SET_CHILDREN_AGES',
)<number[]>();
export const resetHotelsSearchFormAction = createAction(
    'HOTELS.SEARCH_FORM.RESET',
)();

const reducerActions = {
    setHotelsSearchFormToFieldAction,
    setHotelsSearchFormStartDateFieldAction,
    setHotelsSearchFormEndDateFieldAction,
    setHotelsSearchFormAdultsFieldAction,
    setHotelsSearchFormChildrenAgesFieldAction,
    resetHotelsSearchFormAction,
};

export type THotelsSearchFormActions = ActionType<typeof reducerActions>;
