import {createReducer} from 'typesafe-actions';

import {DEFAULT_ADULTS_COUNT, DEFAULT_CHILDREN_AGES} from 'constants/hotels';

import {ESearchFormFieldName} from 'components/SearchForm/types';
import {IHotelsSearchFormValues} from 'projects/hotels/components/SearchForm/types';

import {ESuggestSource} from 'components/SearchSuggest/SearchSuggest';

import {
    setHotelsSearchFormAdultsFieldAction,
    setHotelsSearchFormChildrenAgesFieldAction,
    setHotelsSearchFormEndDateFieldAction,
    setHotelsSearchFormStartDateFieldAction,
    setHotelsSearchFormToFieldAction,
    resetHotelsSearchFormAction,
    THotelsSearchFormActions,
} from 'projects/hotels/containers/SearchForm/reducers/searchForm/actions';

export const SEARCH_FORM_INITIAL_STATE: IHotelsSearchFormValues = {
    [ESearchFormFieldName.TO]: {
        selectedValue: false,
        inputValue: '',
        source: ESuggestSource.INPUT,
    },
    [ESearchFormFieldName.START_DATE]: null,
    [ESearchFormFieldName.END_DATE]: null,
    adults: DEFAULT_ADULTS_COUNT,
    childrenAges: DEFAULT_CHILDREN_AGES,
};

export default createReducer<IHotelsSearchFormValues, THotelsSearchFormActions>(
    SEARCH_FORM_INITIAL_STATE,
)
    .handleAction(setHotelsSearchFormToFieldAction, (state, {payload}) => ({
        ...state,
        [ESearchFormFieldName.TO]: payload,
    }))
    .handleAction(
        setHotelsSearchFormStartDateFieldAction,
        (state, {payload}) => ({
            ...state,
            [ESearchFormFieldName.START_DATE]: payload,
        }),
    )
    .handleAction(
        setHotelsSearchFormEndDateFieldAction,
        (state, {payload}) => ({
            ...state,
            [ESearchFormFieldName.END_DATE]: payload,
        }),
    )
    .handleAction(setHotelsSearchFormAdultsFieldAction, (state, {payload}) => ({
        ...state,
        adults: payload,
    }))
    .handleAction(
        setHotelsSearchFormChildrenAgesFieldAction,
        (state, {payload}) => ({
            ...state,
            childrenAges: payload,
        }),
    )
    .handleAction(resetHotelsSearchFormAction, () => ({
        ...SEARCH_FORM_INITIAL_STATE,
    }));
