import {createReducer, ActionType} from 'typesafe-actions';
import cuid from 'cuid';

import {IHotelsSuggest} from 'types/hotels/common/ISearchSuggest';

import * as actions from './actions';

export const SUGGESTS_INITIAL_STATE = {
    isLoading: false,
    timeMarker: null,
    items: [],
    requestIndex: 0,
    sessionId: '',
};

export interface ISearchSuggest {
    isLoading: boolean;
    timeMarker: number | null;
    items: IHotelsSuggest[];
    requestIndex: number;
    sessionId: string;
}

/* Reducer */
export default createReducer<ISearchSuggest, ActionType<typeof actions>>(
    SUGGESTS_INITIAL_STATE,
)
    .handleAction(actions.fetchSearchSuggestActions.request, state => {
        const {requestIndex, sessionId} = state;

        return {
            ...state,
            requestIndex: requestIndex + 1,
            sessionId: sessionId ? sessionId : cuid(),
            isLoading: true,
        };
    })
    .handleAction(
        actions.fetchSearchSuggestActions.success,
        (state, {payload}): ISearchSuggest => {
            const {timeMarker: lastTimeMarker} = state;
            const {timeMarker, items} = payload;

            if (lastTimeMarker === null || timeMarker >= lastTimeMarker) {
                return {
                    ...state,
                    items,
                    timeMarker,
                    isLoading: false,
                };
            }

            return state;
        },
    )
    .handleAction(
        actions.fetchSearchSuggestActions.failure,
        (): ISearchSuggest => SUGGESTS_INITIAL_STATE,
    );
