import React from 'react';

import {deviceMods} from 'utilities/stylesUtils';

import {hotelsSearchFormTitle} from 'i18n/widget-search-form';

import {useDeviceType} from 'hooks/useDeviceType';

import Card from 'components/Card/Card';
import Text from 'components/Text/Text';
import Separator from 'components/Separator/Separator';
import YandexTravelLogo from 'components/YandexTravelLogo/YandexTravelLogo';

import HotelsSearchFormContainer, {
    IHotelsSearchFormContainer,
} from 'projects/hotels/containers/SearchForm/SearchForm';

import cx from './StandaloneSearchForm.scss';

interface IStandaloneSearchFormProps extends IHotelsSearchFormContainer {}

const StandaloneSearchForm: React.FC<IStandaloneSearchFormProps> = props => {
    const deviceType = useDeviceType();

    return (
        <Card>
            <div
                className={cx(
                    'logoWrapper',
                    deviceMods('logoWrapper', deviceType),
                )}
            >
                <YandexTravelLogo isSmall={deviceType.isMobile} />
            </div>
            <Separator />
            <div className={cx('form', deviceMods('form', deviceType))}>
                <Text
                    className={cx('title', deviceMods('title', deviceType))}
                    size="xl"
                    weight="bold"
                    tag="div"
                >
                    {hotelsSearchFormTitle()}
                </Text>
                <HotelsSearchFormContainer {...props} />
            </div>
        </Card>
    );
};

export default StandaloneSearchForm;
