import React from 'react';
import {render} from 'react-dom';

import {ELocale} from 'types/ELocale';
import {IWidget} from 'types/widgets/IWidget';
import {IWidgetDeps} from 'types/widgets/IWidgetDeps';
import {IBuildOptions} from 'types/widgets/IBuildOptions';

import {setDateLocale} from 'utilities/dateUtils';
import {detectDevice} from 'containers/Widget/utilities/detectDevice';

export class BaseWidget<W> implements IWidget {
    params: W;
    containerId: string;

    constructor(options: IBuildOptions<W>, deps: IWidgetDeps) {
        this.params = options.params || ({} as W);
        this.containerId = options.containerId;
        this.init(options, deps);
    }

    init(options: IBuildOptions<W>, deps: IWidgetDeps): void {
        const widgetRoot = document.getElementById(options.containerId);

        // TODO: внешний moment - заломаем?
        setDateLocale(ELocale.RU);

        if (!widgetRoot) {
            throw new Error(`node with id ${options.containerId} not found`);
        }

        import('containers/Widget/Widget').then(({default: Widget}) =>
            render(
                <Widget
                    deviceType={deps.deviceType || detectDevice()}
                    affiliate={options.affiliate}
                    metrika={deps.metrika}
                    errorBooster={deps.errorBooster}
                >
                    {this.renderWidget()}
                </Widget>,
                widgetRoot,
            ),
        );
    }

    renderWidget(): React.ReactElement {
        return <></>;
    }
}
