import {FunctionComponent, useCallback, useEffect, useState} from 'react';
import WidgetConstructorInput from 'widgets/WidgetConstructor/WidgetConstructorInput/WidgetConstructorInput';
import {SELET_OPTION_FOR_EDIT} from 'widgets/WidgetConstructor/WidgetConstructorControlPanel/WidgetConstructorControlPanel';
import Select from 'widgets/Select/Select';

import {useBoolean} from 'utilities/hooks/useBoolean';

import {ISelectOption} from 'components/SelectOld/SelectOld';

export interface IEditableSelectProps {
    selectedOption: ISelectOption;
    onSelectOption: (selectedOption: ISelectOption) => void;
    options: ISelectOption[];
    uptateOptions: (newOption: ISelectOption) => void;
}

const EditableSelect: FunctionComponent<IEditableSelectProps> = ({
    selectedOption,
    onSelectOption,
    options,
    uptateOptions,
}) => {
    const {
        value: isEditable,
        setTrue: startEdit,
        setFalse: endEdit,
    } = useBoolean(selectedOption.value === SELET_OPTION_FOR_EDIT.value);
    const [inputValue, setInputValue] = useState(selectedOption.text);

    const onChange = useCallback(
        (selectedOption: ISelectOption) => {
            if (selectedOption.value !== SELET_OPTION_FOR_EDIT.value) {
                endEdit();
            }
            onSelectOption(selectedOption);
        },
        [onSelectOption],
    );

    const onBlur = useCallback(() => {
        uptateOptions({text: inputValue, value: inputValue});
        endEdit();
    }, [inputValue, uptateOptions, endEdit]);

    useEffect(() => {
        if (selectedOption.value === SELET_OPTION_FOR_EDIT.value) {
            startEdit();
        }
    }, [selectedOption]);

    return isEditable ? (
        <WidgetConstructorInput
            value={inputValue}
            onChange={setInputValue}
            onBlur={onBlur}
        />
    ) : (
        <Select
            selectedOption={selectedOption}
            onSelectOption={onChange}
            options={options}
        />
    );
};

export default EditableSelect;
