import React from 'react';
import {BaseWidget} from 'widgets/BaseWidget/BaseWidget';

import {TDate} from 'types/common/IDate';

import StandaloneSearchForm from 'projects/hotels/containers/StandaloneSearchForm/StandaloneSearchForm';

export interface IHotelsSearchFormWidget {
    data: {
        pointTo?: {
            hotelSlug?: string;
            regionSlug?: string;
        };
        startDate?: TDate;
        endDate?: TDate;
    };
}

export default class HotelsSearchFormWidget extends BaseWidget<IHotelsSearchFormWidget> {
    renderWidget(): React.ReactElement {
        const {data} = this.params;

        return (
            <StandaloneSearchForm
                initialPointTo={data?.pointTo}
                initialStartDate={data?.startDate}
                initialEndDate={data?.endDate}
            />
        );
    }
}
