import {FunctionComponent, useCallback} from 'react';

import SelectOld, {ISelectOption} from 'components/SelectOld/SelectOld';
import SelectButton from 'components/SelectOld/components/SelectButton/SelectButton';

import cx from './Select.scss';

export interface ISelectProps {
    selectedOption: ISelectOption;
    onSelectOption: (selectedOption: ISelectOption) => void;
    options: ISelectOption[];
}

const Select: FunctionComponent<ISelectProps> = ({
    selectedOption,
    onSelectOption,
    options,
}) => {
    const onChange = useCallback(
        ({value}: {value: string | number; type: string}) => {
            onSelectOption(
                options.find(opt => opt.value === value) || options[0],
            );
        },
        [onSelectOption, options],
    );

    const getSwitcher = useCallback(() => {
        return (
            <SelectButton className={cx('selectButton')}>
                {selectedOption?.text}
            </SelectButton>
        );
    }, [selectedOption]);

    return (
        <div className={cx('travellersSelect')}>
            <SelectOld
                type="widgetConstructorSelect"
                items={options}
                switcherComponent={getSwitcher}
                onChange={onChange}
            />
        </div>
    );
};

export default Select;
