import React from 'react';
import {BaseWidget} from 'widgets/BaseWidget/BaseWidget';

import {EPartner} from 'types/EPartner';

import WidgetConstructorContainer from './WidgetConstructorContainer';

export interface IWidgetConstructor {
    partner?: EPartner; // может прийти пустым
    redirectDomain?: string;
    affiliateClid?: string | string[];
    affiliateVid: string | string[];
    utmSource?: string;
    utmMedia?: string;
    utmCampaign?: string;
    domain?: string; // не нужен, но нужно уметь его принимать
}

export default class WidgetConstructor extends BaseWidget<IWidgetConstructor> {
    renderWidget(): React.ReactElement {
        return (
            <WidgetConstructorContainer
                params={this.params}
                containerId={this.containerId}
            />
        );
    }
}
