import {FunctionComponent, useState} from 'react';

import getAffiliateClidFromParams from './utilities/getAffiliateClidFromParams';
import getAffiliateVidFromParams from './utilities/getAffiliateVidFromParams';
import getUtmsFromParams from './utilities/getUtmsFromParams';

import Flex from 'components/Flex/Flex';

import ConstrutorContext, {
    DEFAULT_REDIRECT_DOMAIN,
    IConstrutorContextParams,
} from 'contexts/ConstrutorContext';

import WidgetConstructorControlPanel from './WidgetConstructorControlPanel/WidgetConstructorControlPanel';
import WidgetPreview from './WidgetPreview/WidgetPreview';
import {IWidgetConstructor} from './WidgetConstructor';

import cx from './WidgetConstructor.scss';

export interface IWidgetConstructorContainerProps {
    params: IWidgetConstructor;
    containerId: string;
}

const WidgetConstructorContainer: FunctionComponent<
    IWidgetConstructorContainerProps
> = ({params, containerId}: IWidgetConstructorContainerProps) => {
    const {partner, affiliateClid, affiliateVid, redirectDomain} = params;

    const {utmSource, utmMedia, utmCampaign} = getUtmsFromParams(params);

    const [currentContext, setCurrentContext] =
        useState<IConstrutorContextParams>({
            clids: Array.isArray(affiliateClid) ? affiliateClid : undefined,
            vids: Array.isArray(affiliateVid) ? affiliateVid : undefined,
            clid: getAffiliateClidFromParams({partner, affiliateClid}),
            vid: getAffiliateVidFromParams({partner, affiliateVid}),
            utmSource,
            utmMedia,
            utmCampaign,
            redirectDomain: redirectDomain || DEFAULT_REDIRECT_DOMAIN,
        });

    return (
        <ConstrutorContext.Provider value={currentContext}>
            <Flex className={cx('root')} justifyContent="flex-end">
                <WidgetPreview containerId={containerId} partner={partner} />

                <WidgetConstructorControlPanel
                    partner={partner}
                    onChange={setCurrentContext}
                />
            </Flex>
        </ConstrutorContext.Provider>
    );
};

export default WidgetConstructorContainer;
