import {FunctionComponent} from 'react';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import InfoPopup from 'components/InfoPopup/InfoPopup';

import cx from './WidgetConstructorControl.scss';

export interface IWidgetConstructorControlProps {
    label: string;
    tooltipText?: string;
}

const WidgetConstructorControl: FunctionComponent<
    IWidgetConstructorControlProps
> = ({children, label, tooltipText}) => {
    return (
        <Flex between={1} flexDirection="column">
            <Flex>
                <Text
                    size="s-inset"
                    color="secondary"
                    className={cx('labelText')}
                >
                    {label}
                </Text>
                {tooltipText && (
                    <InfoPopup iconClassName={cx('infoIcon')}>
                        <Text color="inverse" size="s">
                            {tooltipText}
                        </Text>
                    </InfoPopup>
                )}
            </Flex>

            {children}
        </Flex>
    );
};

export default WidgetConstructorControl;
