import {FunctionComponent, useCallback, useState} from 'react';

import Input from 'components/Input/Input';

export interface IWidgetConstructorInputProps {
    value?: string;
    disableIfValue?: boolean;
    onChange?: (value: string) => void;
    onBlur?: () => void;
}

const WidgetConstructorInput: FunctionComponent<
    IWidgetConstructorInputProps
> = ({
    value,
    disableIfValue,
    onChange,
    onBlur,
}: IWidgetConstructorInputProps) => {
    const [currentValue, setCurrentValue] = useState(value);

    const handleChange = useCallback(
        (event, value) => {
            setCurrentValue(value);
            onChange?.(value);
        },
        [setCurrentValue, onChange],
    );

    return (
        <Input
            onChange={handleChange}
            value={currentValue}
            disabled={Boolean(disableIfValue && value)}
            onBlur={onBlur}
        />
    );
};

export default WidgetConstructorInput;
