import {EPartner} from 'types/EPartner';

export interface IGetAffiliateClidFromParams {
    partner?: EPartner;
    affiliateClid?: string | string[];
}

export default function getAffiliateClidFromParams({
    partner,
    affiliateClid,
}: IGetAffiliateClidFromParams): string | undefined {
    if (!affiliateClid || typeof affiliateClid === 'string') {
        return affiliateClid;
    }

    if (
        typeof affiliateClid === 'object' &&
        partner === EPartner.DISTRIBUTION
    ) {
        return affiliateClid[0];
    }
}
