import {EPartner} from 'types/EPartner';

export interface IGetAffiliateVidFromParams {
    partner?: EPartner;
    affiliateVid?: string | string[];
}

export default function getAffiliateVidFromParams({
    partner,
    affiliateVid,
}: IGetAffiliateVidFromParams): string | undefined {
    if (!affiliateVid || typeof affiliateVid === 'string') {
        return affiliateVid;
    }

    if (typeof affiliateVid === 'object' && partner === EPartner.DISTRIBUTION) {
        return affiliateVid[0];
    }
}
