import {EPartner} from 'types/EPartner';

import {IWidgetConstructor} from '../WidgetConstructor';

export const DEFAULT_UTM_MEDIA = 'cpa';

export default function getUtmsFromParams(params: IWidgetConstructor): {
    utmSource?: string;
    utmMedia?: string;
    utmCampaign?: string;
} {
    const {partner, utmCampaign, utmSource, utmMedia} = params;

    switch (partner) {
        case EPartner.DISTRIBUTION:
            return {
                utmSource: EPartner.DISTRIBUTION,
                utmMedia: DEFAULT_UTM_MEDIA,
                utmCampaign,
            };
        case EPartner.ADMITAD:
            return {
                utmSource: EPartner.ADMITAD,
                utmMedia: DEFAULT_UTM_MEDIA,
                utmCampaign,
            };
        case EPartner.TRAVELPAYOUTS:
            return {
                utmSource,
                utmMedia,
                utmCampaign,
            };
        default:
            return {
                utmSource,
                utmMedia,
                utmCampaign,
            };
    }
}
