import {EPartner} from 'types/EPartner';
import {EWidgetType} from 'types/widgets/EWidgetType';

import {IConstrutorContextParams} from 'contexts/ConstrutorContext';

type TGetWidgetCodeParams = IConstrutorContextParams & {partner?: EPartner};

export default function getWidgetCode(params: TGetWidgetCodeParams) {
    const containerId = 'travelWidgetConstructor';
    const affiliateParams = JSON.stringify(params, undefined, 8);

    return {
        code: `
  <script type="text/javascript">
      (function (w) {
          function start() {
              w.removeEventListener('YaTravelAffiliateLoaded', start);
              w.YaTravelAffiliate.createWidget({
                  type: '${EWidgetType.HOTELS_SEARCH_FORM}',
                  containerId: '${containerId}',
                  affiliate: ${affiliateParams},
              });
          }

          w.YaTravelAffiliate
              ? start()
              : w.addEventListener('YaTravelAffiliateLoaded', start);
      })(window);
  </script>
    `,
        container: `
  <div id="${containerId}"></div>
    `,
    };
}
