import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ArrowBottomIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M10.75 3L6 7.6L1.25 3L0.5 3.72L6 9L11.5 3.72L10.75 3Z"
            fill={props.fill}
        />
    </svg>
);

ArrowBottomIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default ArrowBottomIcon;
