import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ArrowLeftIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M9 10.75L4.4 6L9 1.25L8.28 0.5L3 6L8.28 11.5L9 10.75Z"
            fill={props.fill}
        />
    </svg>
);

ArrowLeftIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default ArrowLeftIcon;
