import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BusIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M11 11.6161C11 11.8281 10.812 12 10.6 12H9.26759C9.10042 12 8.9443 11.9164 8.85157 11.7774L8 10.5H4L3.14843 11.7774C3.0557 11.9164 2.89958 12 2.73241 12H1.4C1.18799 12 1 11.8281 1 11.6161V4.99912L0.0733782 4.57325C0.0263994 4.52635 0 4.4627 0 4.39632V2.75C0 2 0.723858 2 1 2V1.79093C1 1.14098 1.35238 0.564972 2 0.364254C2.80801 0.113824 3.84347 0 6 0C8.15653 0 9.19199 0.113824 10 0.364254C10.6476 0.564972 11 1.14098 11 1.79093V2C11.2761 2 12 2 12 2.75V4.39802C12 4.46339 11.9744 4.52616 11.9287 4.57288L11 5.01092V11.6161ZM6 1.5C4.01211 1.5 2.76517 1.63906 2.25917 1.91717C2.09932 2.00503 2 2.17295 2 2.35535L2 5.625C2 5.83211 2.14924 6 2.33333 6H9.66667C9.85076 6 10 5.83211 10 5.625V2.25125C9.99875 1.75 8.66542 1.5 6 1.5ZM9 9.5C9.55229 9.5 10 9.05229 10 8.5C10 7.94772 9.55229 7.5 9 7.5C8.44771 7.5 8 7.94772 8 8.5C8 9.05229 8.44771 9.5 9 9.5ZM3 9.5C3.55228 9.5 4 9.05229 4 8.5C4 7.94772 3.55228 7.5 3 7.5C2.44772 7.5 2 7.94772 2 8.5C2 9.05229 2.44772 9.5 3 9.5Z"
            fill={props.fill}
        />
    </svg>
);

BusIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default BusIcon;
