import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CheckCircleIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M12 6C12 9.31371 9.31371 12 6 12C2.68629 12 0 9.31371 0 6C0 2.68629 2.68629 0 6 0C9.31371 0 12 2.68629 12 6ZM9.12025 3.5625C8.81066 3.28731 8.33793 3.32041 8.06275 3.63L5.2398 6.94537L3.9225 5.49C3.64157 5.18562 3.16902 5.16407 2.86464 5.445C2.56025 5.72593 2.53895 6.20562 2.81989 6.51L4.41832 8.26695C4.83972 8.72353 5.55146 8.75204 6.00804 8.33064C6.04824 8.29229 6.04825 8.29228 6.08583 8.25138L6.08586 8.25135L9.18775 4.62C9.46294 4.31041 9.42983 3.83769 9.12025 3.5625Z"
            fill={props.fill}
        />
    </svg>
);

CheckCircleIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default CheckCircleIcon;
