import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HotelIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M2 9H10L10.8091 10.6182C10.8834 10.7669 10.9195 10.8157 10.9682 10.8633C11.0169 10.9108 11.0722 10.945 11.1365 10.9673C11.2009 10.9896 11.2607 11 11.4269 11H12V7.64097C12 7.60477 11.9994 7.57232 11.9982 7.54301C11.9994 7.52883 12 7.51449 12 7.5V6.5C12 5.63442 11.3742 4.8957 10.5204 4.7534L8.0335 4.33892C6.88511 4.14752 5.78237 4.87053 5.5 6L5.25 7H3H2.96317H2.92633C2.67538 7 2.51333 6.96853 2.36706 6.90542C2.2208 6.84231 2.09943 6.74755 2.00273 6.62096C1.90603 6.49437 1.8362 6.34479 1.77533 6.10133L1.12585 3.50341C1.0792 3.31679 1.04699 3.25282 0.998635 3.18952C0.950284 3.12623 0.8896 3.07885 0.816468 3.04729C0.743336 3.01573 0.67346 3 0.481096 3H0V11H0.573147C0.739346 11 0.799133 10.9896 0.863467 10.9673C0.9278 10.945 0.983112 10.9108 1.03182 10.8633C1.08053 10.8157 1.11657 10.7669 1.19089 10.6182L2 9ZM5 4.75C5 5.44036 4.44036 6 3.75 6C3.05964 6 2.5 5.44036 2.5 4.75C2.5 4.05964 3.05964 3.5 3.75 3.5C4.44036 3.5 5 4.05964 5 4.75Z"
            fill={props.fill}
        />
    </svg>
);

HotelIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default HotelIcon;
