import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const LocationIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M3.79125 9.19638C2.57648 8.21203 1.2002 7.09681 1.2002 4.8C1.2002 2.148 3.34923 0 6.0002 0C8.65116 0 10.8002 2.14903 10.8002 4.8C10.8002 7.10109 9.42465 8.21766 8.20983 9.20377C7.31293 9.93181 6.50363 10.5887 6.4002 11.5988L6.39572 11.6424C6.37492 11.8455 6.20384 12 5.99965 12C5.7948 12 5.62353 11.8442 5.60415 11.6403L5.6002 11.5988C5.50407 10.5843 4.69207 9.92632 3.79125 9.19638ZM6.00098 6.5C6.8294 6.5 7.50098 5.82843 7.50098 5C7.50098 4.17157 6.8294 3.5 6.00098 3.5C5.17255 3.5 4.50098 4.17157 4.50098 5C4.50098 5.82843 5.17255 6.5 6.00098 6.5Z"
            fill={props.fill}
        />
    </svg>
);

LocationIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default LocationIcon;
