import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const MirCardIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 27 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#e31453c0__clip0_20773_4789)">
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M19.4287 5.63281V9.9931H21.7728V7.42657H24.4295C25.5476 7.41791 26.4974 6.67261 26.8556 5.63281H19.4287Z"
                fill={props.fill}
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M19.1162 2.00488C19.2528 3.80453 20.8844 5.2255 22.8771 5.2255C22.8836 5.2255 26.953 5.2255 26.953 5.2255C26.9831 5.06045 26.9988 4.8901 26.9988 4.71591C26.9988 3.22512 25.8462 2.01591 24.4203 2.00496L19.1162 2.00488Z"
                fill={props.fill}
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M15.6473 5.18267L15.6491 5.17857C15.6731 5.13357 15.7194 5.1032 15.7723 5.1032C15.8487 5.1032 15.9108 5.16671 15.9129 5.24587L15.9129 9.99527H18.2571V2.00488H15.9129C15.6157 2.01521 15.2798 2.24282 15.155 2.52223L13.2895 6.69667C13.2849 6.71374 13.2777 6.72967 13.2684 6.74397L13.2677 6.74536C13.2395 6.78775 13.1923 6.81542 13.1391 6.81542C13.0528 6.81542 12.9828 6.74241 12.9828 6.65235V2.00488H10.6387V9.99527H12.9828V9.99436C13.2768 9.97834 13.6048 9.75328 13.7278 9.47792L15.6425 5.19344C15.6439 5.18977 15.6455 5.18618 15.6473 5.18267Z"
                fill={props.fill}
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M6.89382 5.31926L5.52379 9.99527H3.83748L2.46661 5.31642C2.45339 5.2415 2.39047 5.18473 2.31485 5.18473C2.22962 5.18473 2.16053 5.25683 2.16053 5.34576C2.16053 5.34644 2.16053 5.34712 2.16054 5.3478L2.16053 9.99527H-0.183594V2.00488H1.82844H2.42767C2.85899 2.00488 3.31099 2.35417 3.43703 2.78436L4.57786 6.67806C4.63462 6.8718 4.72671 6.87159 4.78341 6.67806L5.92423 2.78436C6.05036 2.35387 6.50222 2.00488 6.9336 2.00488L7.53264 2.00488H9.5445V9.99527H7.20038V5.3478C7.20038 5.34712 7.20038 5.34644 7.20038 5.34576C7.20038 5.25683 7.13129 5.18473 7.04606 5.18473C6.96948 5.18473 6.90593 5.24293 6.89382 5.31926Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="e31453c0__clip0_20773_4789">
                <rect width={27} height={12} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

MirCardIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default MirCardIcon;
