import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const RefreshIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 13 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M5.65 9.68571C4.57966 9.68571 3.55316 9.26052 2.79632 8.50368C2.03948 7.74684 1.61429 6.72034 1.61429 5.65C1.61429 4.57966 2.03948 3.55316 2.79632 2.79632C3.55316 2.03948 4.57966 1.61429 5.65 1.61429C6.63966 1.6151 7.59366 1.98392 8.32648 2.64904L6.45714 4.36019L12.1088 5.75251L11.2201 1.33712e-06L9.52751 1.54972C8.48223 0.553977 7.09364 -0.00099422 5.65 1.33712e-06C4.15153 1.33712e-06 2.71443 0.595267 1.65485 1.65485C0.595266 2.71443 0 4.15153 0 5.65C0 7.14847 0.595266 8.58557 1.65485 9.64515C2.71443 10.7047 4.15153 11.3 5.65 11.3C6.6989 11.2995 7.72693 11.0069 8.61882 10.4549C9.51071 9.90285 10.2312 9.1133 10.6995 8.17474L9.24582 7.44751C8.58235 8.76961 7.22958 9.68571 5.65 9.68571Z"
            fill={props.fill}
        />
    </svg>
);

RefreshIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default RefreshIcon;
