import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SortAscendingIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M2 3C2 2.44772 2.44772 2 3 2H5C5.55228 2 6 2.44772 6 3C6 3.55228 5.55228 4 5 4H3C2.44772 4 2 3.55228 2 3ZM2 6C2 5.44772 2.44772 5 3 5H7C7.55228 5 8 5.44772 8 6C8 6.55228 7.55228 7 7 7H3C2.44772 7 2 6.55228 2 6ZM2 9C2 8.44772 2.44772 8 3 8H9C9.55228 8 10 8.44772 10 9C10 9.55228 9.55228 10 9 10H3C2.44772 10 2 9.55228 2 9Z"
            fill={props.fill}
        />
    </svg>
);

SortAscendingIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default SortAscendingIcon;
