import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const StarIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M5.98702 9.83363L2.72019 11.9225C2.49156 12.0687 2.19203 11.9949 2.05117 11.7576C1.98257 11.642 1.96171 11.5026 1.99333 11.3709L2.94226 7.41729L0.186142 5.1734C-0.0251408 5.00138 -0.0620572 4.68418 0.103687 4.4649C0.187156 4.35447 0.311168 4.28511 0.445938 4.27348L4.04779 3.9625L5.54576 0.30725C5.65086 0.0507869 5.93639 -0.0686923 6.1835 0.0403861C6.29967 0.0916652 6.39207 0.187827 6.44116 0.308535L7.92712 3.9625L11.5538 4.27371C11.8214 4.29667 12.0204 4.54045 11.9983 4.81819C11.9871 4.95854 11.92 5.08765 11.813 5.17432L9.04575 7.41729L9.99298 11.3737C10.0577 11.6442 9.89897 11.9179 9.63836 11.9851C9.5117 12.0178 9.37772 11.9962 9.26653 11.9253L5.98702 9.83363Z"
            fill={props.fill}
        />
    </svg>
);

StarIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default StarIcon;
