import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SuburbanIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M7.34998 1.6L7.89998 0.499999H8.49998V0.249999C8.49998 0.0999997 8.39998 0 8.24998 0H3.74999C3.59999 0 3.49999 0.0999997 3.49999 0.249999V0.499999H4.09999L4.64999 1.6C3.09999 1.8 1.99999 2.34999 1.99999 2.99999V8.49998C1.99999 8.79998 2.19999 8.99998 2.49999 8.99998H9.49998C9.79998 8.99998 9.99997 8.79998 9.99997 8.49998V2.99999C9.99997 2.34999 8.89998 1.8 7.34998 1.6ZM7.24959 0.500023L6.74959 1.55002C6.49959 1.50002 6.24959 1.50002 5.99959 1.50002C5.74959 1.50002 5.4996 1.50002 5.2496 1.55002L4.7496 0.500023H7.24959ZM5.99959 3.49997C6.29959 3.49997 6.49959 3.29997 6.49959 2.99997C6.49959 2.69997 6.29959 2.49997 5.99959 2.49997C5.6996 2.49997 5.4996 2.69997 5.4996 2.99997C5.4996 3.29997 5.6996 3.49997 5.99959 3.49997ZM4.49882 7.99996H2.99882V6.99996H4.49882V7.99996ZM7.49881 7.99996H8.99881V6.99996H7.49881V7.99996ZM8.99881 5.99996H2.99882V3.99997H8.99881V5.99996ZM3.8996 10.5H3.4996C2.9496 10.5 2.4996 10.05 2.4996 9.5H9.49958C9.49958 10.05 9.04959 10.5 8.49959 10.5H8.14959L8.89959 12H7.89959L7.14959 10.5H4.8496L4.0996 12H3.1496L3.8996 10.5Z"
            fill={props.fill}
        />
    </svg>
);

SuburbanIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default SuburbanIcon;
