import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TrainIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M4.80801 0C4.4768 0 4.18481 0.217251 4.08964 0.534488L3.98857 0.871375C3.31078 0.953175 2.63299 1.07632 1.9552 1.24081C1.39467 1.37685 1 1.87875 1 2.45555L1 8C1 9.10457 1.89544 10 3.00001 10H9C10.1046 10 11 9.10457 11 8L11 2.45554C11 1.87873 10.6053 1.37682 10.0448 1.24081C9.36698 1.07631 8.68919 0.95317 8.0114 0.871372L7.91034 0.534493C7.81517 0.217253 7.52317 0 7.19197 0H4.80801ZM8.82848 6H3.17153C2.76155 6 2.4149 5.7726 2.36071 5.4L2.00725 3.16859C1.95101 2.78189 2.22751 2.42023 2.64317 2.33681C3.76212 2.11227 4.88107 2 6.00001 2C7.11895 2 8.23788 2.11227 9.35682 2.33681C9.77248 2.42022 10.049 2.78187 9.99275 3.16858L9.6393 5.4C9.58512 5.7726 9.23846 6 8.82848 6ZM2.9 9.00001C3.39706 9.00001 3.8 8.59707 3.8 8.10001C3.8 7.60296 3.39706 7.20001 2.9 7.20001C2.40294 7.20001 2 7.60296 2 8.10001C2 8.59707 2.40294 9.00001 2.9 9.00001ZM9.99995 8.10001C9.99995 8.59707 9.59701 9.00001 9.09995 9.00001C8.60289 9.00001 8.19995 8.59707 8.19995 8.10001C8.19995 7.60296 8.60289 7.20001 9.09995 7.20001C9.59701 7.20001 9.99995 7.60296 9.99995 8.10001Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M3.50021 11C3.50021 11 5.28945 11 6.00025 11C7.71105 11 8.50024 11 8.50024 11L9.37399 11.6752C9.44421 11.7176 9.47267 11.8205 9.43756 11.9052C9.41348 11.9633 9.36426 12 9.31041 12C9.31041 12 8.42113 12 6.00025 12C4.31758 12 2.69001 12 2.69001 12C2.6115 12 2.54785 11.9232 2.54785 11.8286C2.54785 11.7636 2.57827 11.7043 2.62644 11.6752L3.50021 11Z"
            fill={props.fill}
        />
    </svg>
);

TrainIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default TrainIcon;
