import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const WarningIcon = (props: IIconProps): ReactElement => (
    <svg viewBox="0 0 12 12" fill="none" focusable={false} {...props}>
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6 12A6 6 0 106 0a6 6 0 000 12zm1-2.966a.934.934 0 00-.954-.954c-.544 0-.966.4-.966.954 0 .555.422.966.966.966.532 0 .954-.41.954-.966zM6.652 2c.19 0 .341.158.333.348L6.78 7.015a.333.333 0 01-.333.318h-.896a.333.333 0 01-.333-.318l-.204-4.667A.333.333 0 015.348 2h1.304z"
            fill={props.fill}
        />
    </svg>
);

WarningIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default WarningIcon;
