import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const YandexEdaIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M9.97452 9.23351C9.0126 10.0931 7.75753 10.6116 6.38814 10.6116C3.51561 10.6116 1.36317 8.35963 1.36317 5.78549C1.36317 3.36491 3.26989 1.38839 5.63385 1.38839C7.86484 1.38839 9.47451 3.13931 9.47451 5.03509C9.47451 6.81214 8.08957 8.25356 6.38814 8.25356C4.83135 8.25356 3.73257 7.05989 3.73257 5.78549C3.73257 4.64169 4.60661 3.74644 5.63463 3.74644C6.54444 3.74644 7.10588 4.41768 7.10588 5.03509C7.10588 5.57098 6.7334 5.89472 6.38814 5.89472C6.26605 5.89472 6.2194 5.8686 6.17041 5.83773C6.2816 5.69288 6.33682 5.50448 6.30882 5.30818C6.25361 4.92902 5.90679 4.66702 5.53431 4.72322C5.21471 4.7715 5.01175 4.99156 4.91144 5.15462C4.79791 5.33747 4.73725 5.55752 4.73725 5.78549C4.73725 6.69499 5.57475 7.28311 6.38814 7.28311C7.57634 7.2839 8.46982 6.23351 8.46982 5.03509C8.46982 3.56834 7.21397 2.35805 5.63463 2.35805C3.80022 2.35805 2.36863 3.93008 2.36863 5.78549C2.36863 7.88786 4.13927 9.64116 6.38892 9.64116C8.87574 9.64116 10.8392 7.54512 10.8392 5.0343C10.8392 2.33509 8.5818 0 5.63463 0C2.49927 0 0 2.61689 0 5.78549C0 9.1686 2.80565 12 6.38892 12C8.10279 12 9.67513 11.3485 10.875 10.2768L9.97452 9.23351ZM6.09964 5.77045C6.09964 5.76887 6.09887 5.76966 6.09964 5.77045V5.77045Z"
            fill={props.fill}
        />
    </svg>
);

YandexEdaIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default YandexEdaIcon;
