import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ActivitiesIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M11.7231 6.32859C10.7049 8.87402 10.1818 11.5904 10.1818 14.3319C10.1818 14.6952 10.352 15.0388 10.6652 15.223C11.2128 15.5453 12.1519 16 13.0909 16C14.0299 16 14.969 15.5453 15.5166 15.223C15.8298 15.0388 16 14.6952 16 14.3319C16 11.5904 15.4769 8.87402 14.4587 6.32859L14.4038 6.19123C14.0485 5.30311 14.3043 4.29262 14.6608 3.40499C14.8048 3.04633 14.9091 2.63145 14.9091 2.18182C14.9091 0.727273 14.1818 0 13.0909 0C12 0 11.2727 0.727273 11.2727 2.18182C11.2727 2.63145 11.377 3.04633 11.521 3.40499C11.8775 4.29262 12.1333 5.30311 11.7781 6.19123L11.7231 6.32859Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M9.47314 11.6849C9.45455 12.0134 9.45455 12.3449 9.45455 13.0078V13.8425C9.45455 14.2018 9.45455 14.472 9.47788 14.7051C8.47825 15.5149 7.20487 16 5.81818 16C2.60489 16 0 13.3951 0 10.1818C0 6.96853 2.60489 4.36364 5.81818 4.36364C7.85149 4.36364 9.64118 5.40666 10.6814 6.98686C10.6289 7.12839 10.5602 7.30722 10.469 7.54424C10.2311 8.16288 10.112 8.47231 10.0115 8.78556C9.7098 9.72528 9.5289 10.6996 9.47314 11.6849ZM4.54545 8.36364C5.14795 8.36364 5.63636 7.87522 5.63636 7.27273C5.63636 6.67023 5.14795 6.18182 4.54545 6.18182C3.94296 6.18182 3.45455 6.67023 3.45455 7.27273C3.45455 7.87522 3.94296 8.36364 4.54545 8.36364ZM7.27273 10.1818C7.27273 10.7843 6.78431 11.2727 6.18182 11.2727C5.57933 11.2727 5.09091 10.7843 5.09091 10.1818C5.09091 9.57933 5.57933 9.09091 6.18182 9.09091C6.78431 9.09091 7.27273 9.57933 7.27273 10.1818ZM2.90909 11.2727C3.51158 11.2727 4 10.7843 4 10.1818C4 9.57933 3.51158 9.09091 2.90909 9.09091C2.3066 9.09091 1.81818 9.57933 1.81818 10.1818C1.81818 10.7843 2.3066 11.2727 2.90909 11.2727Z"
            fill={props.fill}
        />
    </svg>
);

ActivitiesIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ActivitiesIcon;
