import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const AdjustableSeatIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M9.52496 4.52853C9.23446 4.23605 9.23446 3.76395 9.52496 3.47147L12.1182 0.860565C12.4327 0.543937 12.973 0.766647 12.973 1.21292L12.973 3L15 3C15.5523 3 16 3.44772 16 4C16 4.55228 15.5523 5 15 5L12.973 5L12.973 6.78708C12.973 7.23335 12.4327 7.45606 12.1182 7.13944L9.52496 4.52853Z"
            fill={props.fill}
        />
        <path
            d="M1.05615 1.38822C0.824857 0.708929 1.33669 0.00599966 2.06691 9.10609e-05C3.41492 -0.0108165 4.56258 0.959374 4.75033 2.26854L5.7932 9.54044C5.85421 9.52239 5.91634 9.50691 5.97945 9.49411L10.6793 8.54083C12.201 8.23217 13.6861 9.20405 13.9796 10.7006C14.1118 11.3747 13.5851 12 12.8852 12L5.52325 12C5.01082 12.0002 4.4984 11.4977 4.33885 11.0291L1.05615 1.38822Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M9 15.9395C8.44772 15.9395 8 15.4917 8 14.9395L8 10.9395C8 10.3872 8.44772 9.93945 9 9.93945C9.55228 9.93945 10 10.3872 10 10.9395L10 14.9395C10 15.4917 9.55228 15.9395 9 15.9395Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M5.91357 15C5.91357 14.4477 6.36129 14 6.91357 14L10.9136 14C11.4659 14 11.9136 14.4477 11.9136 15C11.9136 15.5523 11.4659 16 10.9136 16L6.91357 16C6.36129 16 5.91357 15.5523 5.91357 15Z"
            fill={props.fill}
        />
    </svg>
);

AdjustableSeatIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default AdjustableSeatIcon;
