import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const AirConditionerIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M14.792 10.9736L13.66 10.3256L13.9848 10.2488C14.0887 10.2265 14.187 10.1836 14.2741 10.1227C14.3612 10.0619 14.4353 9.98424 14.492 9.89439C14.5487 9.80453 14.5869 9.70426 14.6043 9.59946C14.6218 9.49465 14.6181 9.38742 14.5936 9.28404C14.4888 8.85364 14.0416 8.58884 13.6032 8.69124L11.6256 9.15204L9.62242 8.00005L11.6256 6.84806L13.6072 7.30885C13.6736 7.32165 13.7352 7.33045 13.8008 7.33045C14.1728 7.33045 14.5104 7.08245 14.5984 6.71606C14.6229 6.61262 14.6265 6.50533 14.609 6.40049C14.5915 6.29564 14.5532 6.19534 14.4965 6.10547C14.4397 6.01561 14.3655 5.93799 14.2784 5.87716C14.1912 5.81634 14.0927 5.77354 13.9888 5.75126L13.6648 5.67446L14.796 5.02647C14.8883 4.97471 14.9692 4.9049 15.034 4.82121C15.0988 4.73752 15.146 4.64165 15.173 4.53932C15.1999 4.43698 15.206 4.33027 15.1908 4.22553C15.1757 4.1208 15.1396 4.02018 15.0848 3.92968C14.9704 3.74566 14.7888 3.61339 14.5786 3.56083C14.3684 3.50828 14.146 3.53957 13.9584 3.64808L12.8448 4.28807L12.9232 3.96008C12.9477 3.8567 12.9514 3.74946 12.9339 3.64466C12.9165 3.53985 12.8783 3.43958 12.8216 3.34973C12.7649 3.25987 12.6908 3.18224 12.6037 3.12138C12.5166 3.06051 12.4183 3.01764 12.3144 2.99528C11.876 2.89288 11.4288 3.15768 11.3232 3.58808L10.872 5.42407L8.82403 6.60006V4.28807L10.2184 2.97848C10.2963 2.9069 10.3588 2.82029 10.4022 2.72387C10.4456 2.62745 10.4691 2.52323 10.4711 2.4175C10.4731 2.31178 10.4537 2.20674 10.414 2.10873C10.3742 2.01072 10.3151 1.92179 10.24 1.84729C10.0864 1.69483 9.87981 1.60757 9.6634 1.60369C9.44698 1.59982 9.23743 1.67963 9.07842 1.82649L8.82883 2.06089V0.802496C8.82883 0.358499 8.46083 0.000101696 8.00483 0.000101696C7.89812 -0.00159144 7.79213 0.0178723 7.69299 0.0573688C7.59384 0.0968654 7.5035 0.155612 7.42719 0.230217C7.35087 0.304821 7.29009 0.393806 7.24836 0.492031C7.20662 0.590256 7.18476 0.695775 7.18404 0.802496V2.07769L6.95204 1.84729C6.79895 1.6935 6.59202 1.60533 6.37506 1.60144C6.15809 1.59756 5.94814 1.67827 5.78965 1.82649C5.71188 1.898 5.6494 1.98453 5.60598 2.08084C5.56255 2.17716 5.53909 2.28127 5.537 2.3869C5.5349 2.49253 5.55423 2.59749 5.5938 2.69545C5.63337 2.79341 5.69237 2.88234 5.76725 2.95688L7.17924 4.38167V6.60086L5.13125 5.42327L4.68005 3.58808C4.62587 3.37902 4.49163 3.19966 4.30632 3.08874C4.12101 2.97783 3.89951 2.94426 3.68966 2.99528C3.5858 3.01756 3.48744 3.06034 3.40032 3.12111C3.31321 3.18188 3.2391 3.25943 3.18232 3.3492C3.12555 3.43898 3.08727 3.53918 3.06971 3.64393C3.05215 3.74869 3.05567 3.8559 3.08006 3.95928L3.15926 4.29207L2.04087 3.65208C1.85326 3.54377 1.6309 3.5126 1.42074 3.56514C1.21058 3.61768 1.02905 3.74982 0.914479 3.93368C0.859636 4.02418 0.823565 4.1248 0.808414 4.22953C0.793263 4.33427 0.799341 4.44098 0.826288 4.54332C0.853234 4.64565 0.900498 4.74152 0.965264 4.82521C1.03003 4.9089 1.11097 4.97871 1.20328 5.03047L2.33447 5.67846L2.01047 5.75606C1.90669 5.77843 1.80841 5.82128 1.72138 5.88209C1.63436 5.9429 1.56033 6.02045 1.50364 6.11022C1.44695 6.19998 1.40874 6.30015 1.39123 6.40487C1.37372 6.50958 1.37727 6.61673 1.40168 6.72006C1.48967 7.08725 1.82727 7.33445 2.19927 7.33445C2.26087 7.33445 2.32727 7.32645 2.39287 7.31285L4.37446 6.85206L6.37764 8.00405L4.37446 9.15604L2.39287 8.69524C1.95847 8.59284 1.50727 8.85764 1.40168 9.28884C1.37728 9.39222 1.37376 9.49943 1.39132 9.60418C1.40888 9.70894 1.44717 9.80914 1.50394 9.89891C1.56071 9.98869 1.63482 10.0662 1.72193 10.127C1.80905 10.1878 1.90742 10.2306 2.01127 10.2528L2.33527 10.3296L1.20408 10.9776C1.11177 11.0294 1.03083 11.0992 0.966064 11.1829C0.901298 11.2666 0.854034 11.3624 0.827088 11.4648C0.800141 11.5671 0.794063 11.6738 0.809214 11.7786C0.824365 11.8833 0.860436 11.9839 0.915279 12.0744C1.06888 12.3264 1.34488 12.4672 1.62567 12.4672C1.76567 12.4672 1.91047 12.4328 2.04167 12.356L3.16006 11.716L3.08086 12.0488C3.05635 12.1523 3.05274 12.2595 3.07024 12.3644C3.08774 12.4692 3.126 12.5695 3.18278 12.6594C3.23956 12.7493 3.31372 12.8269 3.4009 12.8877C3.48807 12.9485 3.58652 12.9913 3.69046 13.0136C3.75606 13.0264 3.81766 13.0344 3.88246 13.0344C4.25606 13.0344 4.59365 12.7872 4.68085 12.42L5.13285 10.5856L7.18084 9.40804V11.72L5.78565 13.0304C5.70793 13.102 5.64551 13.1886 5.60216 13.2849C5.55881 13.3812 5.53542 13.4854 5.5334 13.591C5.53138 13.6966 5.55078 13.8016 5.59042 13.8995C5.63006 13.9974 5.68912 14.0863 5.76405 14.1608C5.92645 14.3232 6.14084 14.404 6.35604 14.404C6.56164 14.404 6.76804 14.332 6.92564 14.1784L7.17604 13.9432V15.2024C7.17604 15.6456 7.54403 16 7.99603 16C8.45203 16 8.82003 15.6416 8.82003 15.2024V13.9264L9.05202 14.1568C9.36802 14.4768 9.88962 14.4848 10.2144 14.1784C10.2923 14.1068 10.3548 14.0202 10.3982 13.9238C10.4416 13.8274 10.4651 13.7232 10.4671 13.6174C10.4691 13.5117 10.4497 13.4067 10.41 13.3087C10.3702 13.2106 10.3111 13.1217 10.236 13.0472L8.82403 11.6224V9.40804L10.872 10.5856L11.3232 12.42C11.4112 12.7872 11.7488 13.0344 12.1216 13.0344C12.1824 13.0344 12.248 13.0264 12.3136 13.0136C12.4175 12.9913 12.516 12.9485 12.6032 12.8877C12.6903 12.8269 12.7645 12.7493 12.8213 12.6594C12.8781 12.5695 12.9163 12.4692 12.9338 12.3644C12.9513 12.2595 12.9477 12.1523 12.9232 12.0488L12.8448 11.7208L13.9584 12.3608C14.0896 12.4376 14.2344 12.4712 14.3744 12.4712C14.6552 12.4712 14.9312 12.3304 15.0848 12.0792C15.1391 11.9876 15.1746 11.8861 15.1892 11.7806C15.2038 11.6751 15.1973 11.5678 15.1699 11.4648C15.1426 11.3619 15.095 11.2655 15.03 11.1811C14.965 11.0968 14.8838 11.0262 14.7912 10.9736H14.792Z"
            fill={props.fill}
        />
    </svg>
);

AirConditionerIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default AirConditionerIcon;
