import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const AnimalsIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M11.0895 0.0547025L11.9435 1.41871L13.5395 1.64669C13.6335 1.66013 13.7173 1.71297 13.77 1.79199L13.9098 2.00164H15.8664C15.9489 2.00164 16.0117 2.07573 15.9981 2.15712L15.9254 2.59339C15.7847 3.43761 15.1236 4.09874 14.281 4.24855C13.9806 4.30195 13.6507 4.36152 13.3103 4.42451C13.1753 4.47388 13.0522 4.53083 12.9426 4.58938C12.5292 4.81005 12.3286 5.26171 12.2862 5.72836L12.2658 5.95308C11.5271 5.72688 10.871 5.39777 10.2955 4.96609C10.0103 4.7522 9.7519 4.51845 9.52008 4.26451C9.61712 4.07351 9.70577 3.87226 9.79459 3.67063C9.95134 3.31479 10.1086 2.95777 10.3134 2.65386C10.1436 0.993318 10.6493 0.288988 10.8828 0.0546988C10.9359 0.00139977 11.0495 -0.0090705 11.0895 0.0547025Z"
            fill={props.fill}
        />
        <path
            d="M8.97197 5.04545C8.77001 5.23069 7.85285 6.00765 6.67669 6.00765H3.33835C1.54607 6.00765 1.32478 8.75689 1.31897 10.0382L0.112135 11.8485C0.0390173 11.9581 0 12.087 0 12.2188V14.6874C0 15.0561 0.298926 15.355 0.667669 15.355H1.94213C1.97575 15.355 2.00301 15.3278 2.00301 15.2941C2.00301 14.81 1.77331 14.3608 1.39435 14.0766C1.55265 13.1648 2.0214 11.8605 3.33835 11.4466C4.31335 11.0345 4.66247 10.3135 4.85089 10.0137H5.2939C6.17929 10.0137 7.01718 10.3968 7.79411 10.8214C7.97972 10.9228 8.18369 11.0197 8.4023 11.1022L9.23119 14.8322C9.29907 15.1377 9.57002 15.355 9.88296 15.355H11.2991C11.3274 15.355 11.3504 15.3321 11.3504 15.3038C11.3504 14.7981 11.1023 14.3302 10.6961 14.0452C10.7373 13.0492 10.8621 11.6459 11.2167 10.4203C11.5837 9.91374 11.8144 9.3209 11.9294 8.97379C11.9589 8.88481 11.9818 8.79435 11.9998 8.70285L12.018 8.67833C12.0155 8.66812 12.0128 8.65808 12.01 8.64818C12.0261 8.55622 12.0376 8.46331 12.0461 8.36989L12.1795 6.90182C11.2638 6.6447 10.4479 6.24887 9.73462 5.71388C9.45946 5.50751 9.2052 5.28464 8.97197 5.04545Z"
            fill={props.fill}
        />
        <path
            d="M0.274765 2.09692C0.295536 1.98494 0.433128 1.95856 0.495747 2.0537C0.9149 2.69051 2.00301 4.47343 2.00301 5.82111C-0.234623 5.82111 0.1056 3.00891 0.274765 2.09692Z"
            fill={props.fill}
        />
    </svg>
);

AnimalsIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default AnimalsIcon;
