import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const AntisepticIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M7.33335 0.333333C7.33335 0.149238 7.48259 0 7.66669 0H8.33335C8.51745 0 8.66669 0.149238 8.66669 0.333333V0.54306C8.66669 0.618814 8.62178 0.687415 8.56979 0.742511C8.51878 0.796569 8.46669 0.880921 8.46669 1C8.46669 1.11908 8.51878 1.20343 8.56979 1.25749C8.62178 1.31258 8.66669 1.38119 8.66669 1.45694V1.66667C8.66669 1.85076 8.51745 2 8.33335 2H7.66669C7.48259 2 7.33335 1.85076 7.33335 1.66667V0.333333Z"
            fill={props.fill}
        />
        <path
            d="M8.00154 4.66667C11 4.66667 10.6637 3.73333 10.6637 3.73333C10.5795 3.17205 10.1061 2.69442 9.40377 2.38905C9.33125 2.35752 9.24863 2.39795 9.22576 2.47365C9.19113 2.58826 9.08553 2.66667 8.9658 2.66667H7.03549C6.91602 2.66667 6.81075 2.58815 6.77668 2.47364C6.7542 2.39805 6.67184 2.35753 6.59952 2.38897C5.89707 2.69434 5.42366 3.172 5.33944 3.73333C5.33944 3.73333 5.00306 4.66667 8.00154 4.66667Z"
            fill={props.fill}
        />
        <path
            d="M8.00002 11.8333C8.82845 11.8333 9.50002 11.1618 9.50002 10.3333C9.50002 9.50491 8.82845 8.83333 8.00002 8.83333C7.17159 8.83333 6.50002 9.50491 6.50002 10.3333C6.50002 11.1618 7.17159 11.8333 8.00002 11.8333Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M4.83327 4.65611C4.81452 4.6341 4.78769 4.62051 4.75877 4.62051C4.70792 4.62051 4.66669 4.66174 4.66669 4.71259V14.5963C4.66669 14.8595 4.74727 15.12 4.95986 15.2752C5.36528 15.5712 6.25389 16 8.00002 16C9.74615 16 10.6348 15.5712 11.0402 15.2752C11.2528 15.12 11.3334 14.8595 11.3334 14.5963V4.71259C11.3334 4.66174 11.2921 4.62051 11.2413 4.62051C11.2124 4.62051 11.1855 4.6341 11.1668 4.65611C10.9061 4.96213 10.1161 5.43333 8.00002 5.43333C5.88398 5.43333 5.09396 4.96213 4.83327 4.65611ZM10.3334 10.3333C10.3334 11.622 9.28869 12.6667 8.00002 12.6667C6.71136 12.6667 5.66669 11.622 5.66669 10.3333C5.66669 9.04467 6.71136 8 8.00002 8C9.28869 8 10.3334 9.04467 10.3334 10.3333Z"
            fill={props.fill}
        />
        <path
            d="M11.8334 1C12.1095 1 12.3334 0.776142 12.3334 0.5C12.3334 0.223858 12.1095 0 11.8334 0C11.5572 0 11.3334 0.223858 11.3334 0.5C11.3334 0.776142 11.5572 1 11.8334 1Z"
            fill={props.fill}
        />
        <path
            d="M10.6667 1C10.6667 1.27614 10.4428 1.5 10.1667 1.5C9.89055 1.5 9.66669 1.27614 9.66669 1C9.66669 0.723858 9.89055 0.5 10.1667 0.5C10.4428 0.5 10.6667 0.723858 10.6667 1Z"
            fill={props.fill}
        />
        <path
            d="M11.5 2.66667C11.7762 2.66667 12 2.44281 12 2.16667C12 1.89052 11.7762 1.66667 11.5 1.66667C11.2239 1.66667 11 1.89052 11 2.16667C11 2.44281 11.2239 2.66667 11.5 2.66667Z"
            fill={props.fill}
        />
    </svg>
);

AntisepticIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default AntisepticIcon;
