import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ArrowRightIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M9.58228 8L4.79241 3.20687C4.40202 2.81621 4.40223 2.18304 4.79289 1.79265C5.18355 1.40226 5.81671 1.40248 6.2071 1.79313L11.7034 7.29313C12.0936 7.6836 12.0936 8.3164 11.7034 8.70687L6.2071 14.2069C5.81671 14.5975 5.18355 14.5977 4.79289 14.2073C4.40223 13.817 4.40202 13.1838 4.79241 12.7931L9.58228 8Z"
            fill={props.fill}
        />
    </svg>
);

ArrowRightIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ArrowRightIcon;
