import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BalconyIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M0 9C0 8.44772 0.447715 8 1 8H15C15.5523 8 16 8.44772 16 9C16 9.55228 15.5523 10 15 10H1C0.447715 10 0 9.55228 0 9Z"
            fill={props.fill}
        />
        <rect y={14} width={16} height={2} rx={1} fill={props.fill} />
        <mask id="49cfa749__path-3-inside-1_12635_19" fill="white">
            <rect x={2} y={1} width={12} height={9} rx={1} />
        </mask>
        <rect
            x={2}
            y={1}
            width={12}
            height={9}
            rx={1}
            stroke={props.fill}
            strokeWidth={4}
            mask="url(#49cfa749__path-3-inside-1_12635_19)"
        />
        <path d="M1.5 10H3.5V14H1.5V10Z" fill={props.fill} />
        <path d="M12.5 10H14.5V14H12.5V10Z" fill={props.fill} />
        <path d="M7 10L9 10V14H7V10Z" fill={props.fill} />
        <path d="M7 2H9V9H7V2Z" fill={props.fill} />
    </svg>
);

BalconyIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default BalconyIcon;
