import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BeachIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8.37597 7.75588L9.72396 11.4595C9.26136 11.4554 8.80028 11.4838 8.33506 11.5419L7.12244 8.21025C7.32018 8.135 7.52153 8.06008 7.7265 7.98548C7.94578 7.90566 8.16227 7.82913 8.37597 7.75588ZM5.76132 0.438835L5.89365 0.802428C5.66044 0.83246 5.43533 0.885336 5.21835 0.961057C5.01532 1.03191 4.81973 1.12265 4.63157 1.23327L4.50839 0.894861C4.38247 0.548876 4.56086 0.166315 4.90684 0.0403864C5.25283 -0.085542 5.63539 0.0928494 5.76132 0.438835ZM14.3457 5.06269C13.4061 3.67208 10.8387 0.737379 6.27941 1.51468C6.94477 2.15933 7.79341 3.49742 8.82534 5.52895C8.27837 5.70047 7.71329 5.89243 7.12995 6.10475C6.54401 6.31802 5.9853 6.5352 5.45376 6.75647C4.93527 4.52341 4.72582 2.94725 4.82541 2.02799C0.759482 4.3585 0.677686 8.29551 0.852961 9.97451C0.891531 10.344 1.32084 10.4998 1.62532 10.287C2.56428 9.63069 4.52908 8.41561 7.53228 7.32253C10.5333 6.23027 12.8148 5.89908 13.9546 5.79881C14.3249 5.76624 14.5538 5.37067 14.3457 5.06269ZM3.3326 13.7766C3.11246 13.8507 2.89059 13.9254 2.66663 14C2.66663 14.3682 2.9651 14.6667 3.33329 14.6667H13.3333C14.0697 14.6667 14.6666 14.0697 14.6666 13.3333C10.2613 11.4453 7.04408 12.5278 3.3326 13.7766Z"
            fill={props.fill}
        />
    </svg>
);

BeachIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default BeachIcon;
