import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BedIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M2.57364 3.7723C2.21562 3.89596 2 4.23926 2 4.61803V7.04999C2.16152 7.01721 2.32869 7 2.49988 7L3 7.00001C3 5.5 4 5 5.5 5C7 5 8 5.5 8 7C8 5.5 9 5 10.5 5C12 5 13 5.5 13 7.00003L13.5001 7.00003C13.6713 7.00003 13.8385 7.01724 14 7.05002V4.61803C14 4.23926 13.7844 3.89596 13.4264 3.7723C12.572 3.4772 10.7632 3 8 3C5.23681 3 3.42803 3.4772 2.57364 3.7723Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M12.5 13H3.5L3.19089 13.6182C3.11657 13.7669 3.08053 13.8157 3.03182 13.8633C2.98311 13.9108 2.9278 13.945 2.86347 13.9673C2.79913 13.9896 2.73935 14 2.57315 14H1V9.5C1 8.67158 1.67158 8 2.5 8L13.5 8.00004C14.3284 8.00004 15 8.67161 15 9.50004V14H13.4269C13.2607 14 13.2009 13.9896 13.1365 13.9673C13.0722 13.945 13.0169 13.9108 12.9682 13.8633C12.9195 13.8157 12.8834 13.7669 12.8091 13.6182L12.5 13Z"
            fill={props.fill}
        />
    </svg>
);

BedIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default BedIcon;
