import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BedclothesIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M16 13.7273V10.0876C16 9.75992 15.9662 9.6411 15.9029 9.52132C15.8395 9.40153 15.7465 9.30753 15.6279 9.24346C15.5094 9.1794 15.3919 9.14529 15.0677 9.14529H3.20828C2.58617 9.14529 2.36017 9.08395 2.12969 8.96661C1.8992 8.84927 1.71501 8.67593 1.58278 8.45194C1.45056 8.22794 1.37392 8.00448 1.3296 7.37733L1.12215 4.44199C1.11107 4.2852 1.09191 4.22934 1.05885 4.17334C1.02579 4.11734 0.979745 4.074 0.922124 4.04467C0.864502 4.01533 0.808003 4 0.652477 4H0V13.7273H0.699776C0.979578 13.7273 1.08122 13.7041 1.18759 13.6578C1.29396 13.6114 1.38223 13.5417 1.45256 13.4487C1.52289 13.3556 1.56974 13.2616 1.6376 12.9872L1.81818 12.2572H14.1818L14.3624 12.9872C14.4303 13.2616 14.4771 13.3556 14.5474 13.4487C14.6178 13.5417 14.706 13.6114 14.8124 13.6578C14.9188 13.7041 15.0204 13.7273 15.3002 13.7273H16Z"
            fill={props.fill}
        />
        <path
            d="M12.8961 4.84147C14.2421 4.96514 15.2727 6.10576 15.2727 7.47177C15.2727 7.7635 15.0387 8 14.7501 8H6.79062C6.32485 8 6.00635 7.52455 6.17934 7.08747C6.82809 5.44827 8.46504 4.43434 10.2047 4.59418L12.8961 4.84147Z"
            fill={props.fill}
        />
        <path
            d="M5.45455 5.79488C5.45455 6.60678 4.80332 7.26496 4 7.26496C3.19668 7.26496 2.54545 6.60678 2.54545 5.79488C2.54545 4.98297 3.19668 4.32479 4 4.32479C4.80332 4.32479 5.45455 4.98297 5.45455 5.79488Z"
            fill={props.fill}
        />
    </svg>
);

BedclothesIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default BedclothesIcon;
