import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BreakfastIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M15.3334 5.33332V4.99999C15.3334 3.71133 14.2887 2.66666 13 2.66666H12.1447C12.1125 2.66666 12.0805 2.66724 12.0485 2.66839C12.0325 2.66724 12.0163 2.66666 12 2.66666H2.66671C2.29852 2.66666 2.00004 2.96513 2.00004 3.33332C2.00004 7.33332 2.01972 11.3333 7.33337 11.3333C9.31464 11.3333 10.5599 10.7772 11.3426 9.87234C11.4753 9.71884 11.7166 9.42542 11.9278 9.16649C12.1952 8.83859 12.5369 8.5801 12.9039 8.3696C13.7742 7.87051 15.3334 6.77516 15.3334 5.33332ZM12.6656 3.99999H13C13.5523 3.99999 14 4.44771 14 4.99999V5.33332C14 6.0697 13.4031 6.66666 12.6667 6.66666H12.5391C12.6406 5.82194 12.6614 4.91685 12.6656 3.99999Z"
            fill={props.fill}
        />
        <path
            d="M1.93752 12C1.60386 12 1.33337 12.2705 1.33337 12.6041C1.33337 12.8445 1.47507 13.0604 1.70204 13.1396C2.48995 13.4146 4.49975 14 7.33337 14C10.167 14 12.1768 13.4146 12.9647 13.1396C13.1917 13.0604 13.3334 12.8445 13.3334 12.6041C13.3334 12.2705 13.0629 12 12.7292 12H1.93752Z"
            fill={props.fill}
        />
    </svg>
);

BreakfastIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default BreakfastIcon;
