import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CalendarIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M4 0C3.44772 0 3 0.447717 3 1.00001V2.00001H2.5C1.67157 2.00001 1 2.67158 1 3.50001V13.5C1 14.3285 1.67157 15 2.5 15H13.5C14.3284 15 15 14.3285 15 13.5V3.50001C15 2.67158 14.3284 2.00001 13.5 2.00001H13V1.00001C13 0.447717 12.5523 0 12 0C11.4477 0 11 0.447717 11 1.00001V2.00001H5V1.00001C5 0.447717 4.55228 0 4 0ZM3 6.00002V13H13V6.00002H3ZM11.5 9.99998C11.5 10.8285 10.8284 11.5 10 11.5C9.17157 11.5 8.5 10.8285 8.5 9.99998C8.5 9.1716 9.17157 8.50003 10 8.50003C10.8284 8.50003 11.5 9.1716 11.5 9.99998Z"
            fill={props.fill}
        />
    </svg>
);

CalendarIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default CalendarIcon;
