import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CheckCircleIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM12.1603 4.75C11.7475 4.38308 11.1172 4.42722 10.7503 4.84L6.9864 9.26049L5.23 7.32C4.85542 6.91416 4.22536 6.88542 3.81952 7.26C3.41367 7.63458 3.38527 8.27415 3.75985 8.68L5.89109 11.0226C6.45296 11.6314 7.40195 11.6694 8.01071 11.1075C8.03753 11.0819 8.05093 11.0692 8.0639 11.0559C8.07687 11.0427 8.08941 11.0291 8.11448 11.0018L12.2503 6.16C12.6172 5.74722 12.5731 5.11692 12.1603 4.75Z"
            fill={props.fill}
        />
    </svg>
);

CheckCircleIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default CheckCircleIcon;
