import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ChildIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8 5.5C8.69036 5.5 9.25 4.94036 9.25 4.25C9.25 3.55964 8.69036 3 8 3C7.30964 3 6.75 3.55964 6.75 4.25C6.75 4.94036 7.30964 5.5 8 5.5ZM6 8.45767C5.2417 8.58113 4.49288 8.77532 3.76437 9.04023C3.15145 9.26311 2.5 8.81044 2.5 8.15826C2.5 7.76307 2.74723 7.4101 3.11863 7.27505L3.55734 7.11551C6.42719 6.07193 9.57281 6.07193 12.4427 7.11551L12.8814 7.27505C13.2528 7.4101 13.5 7.76307 13.5 8.15826C13.5 8.81044 12.8486 9.26311 12.2356 9.04023C11.5071 8.77532 10.7583 8.58113 10 8.45767V15C10 15.5523 9.55228 16 9 16C8.44772 16 8 15.5523 8 15C8 15.5523 7.55228 16 7 16C6.44772 16 6 15.5523 6 15V8.45767Z"
            fill={props.fill}
        />
    </svg>
);

ChildIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ChildIcon;
