import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CovidShildIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8 0C6 1 3.5 2.1383 1 2L1.5 8.83443C1.5 10.3384 2.25442 11.7477 3.52113 12.6101L8 16L12.4789 12.6101C13.7456 11.7477 14.5 10.3384 14.5 8.83443L15 2C12.5 2.1383 10 1 8 0ZM11.1484 3.82451C11.0193 4.08885 10.7172 4.22613 10.3798 4.20765L9.46477 5.79254C9.63551 5.93921 9.784 6.11104 9.90449 6.30228L11.3485 5.91537C11.6152 5.84389 11.8894 6.00219 11.9609 6.26892C12.0323 6.53565 11.874 6.80982 11.6073 6.88129L10.2356 7.24885C10.2447 7.33131 10.2494 7.41511 10.2494 7.50001C10.2494 7.67832 10.2287 7.85179 10.1895 8.01814L11.8011 8.94859C12.0525 8.78409 12.344 8.74637 12.5778 8.87696C12.9517 9.08578 13.0365 9.64595 12.7672 10.1281C12.4978 10.6103 11.9764 10.8319 11.6026 10.623C11.3357 10.474 11.2162 10.1461 11.2674 9.7952L9.74697 8.91736C9.56568 9.14062 9.34246 9.32846 9.08931 9.46889L9.69985 11.7475C9.77132 12.0142 9.61302 12.2884 9.34629 12.3598C9.07956 12.4313 8.80539 12.273 8.73392 12.0063L8.12838 9.74637C8.0857 9.74878 8.0427 9.75001 7.99942 9.75001C7.73782 9.75001 7.48664 9.70536 7.2531 9.62327L6.45324 11.0087C6.65269 11.2733 6.70771 11.5937 6.56599 11.8463C6.35643 12.2198 5.7961 12.3034 5.31446 12.0332C4.83281 11.7629 4.61224 11.2411 4.82179 10.8676C4.96092 10.6197 5.25467 10.4995 5.57735 10.5258L6.40671 9.08927C6.2102 8.89233 6.04997 8.65917 5.93693 8.40066L3.67397 9.00702C3.40723 9.07849 3.13307 8.9202 3.06159 8.65347C2.99012 8.38674 3.14842 8.11257 3.41515 8.0411L5.75099 7.41521C5.76036 7.16223 5.8115 6.91993 5.89771 6.69499L5.02502 6.19114C4.76624 6.37923 4.45685 6.42976 4.21022 6.29379C3.83518 6.08704 3.74731 5.52736 4.01394 5.0437C4.28057 4.56004 4.80075 4.33556 5.17578 4.54231C5.43182 4.68346 5.55401 4.98911 5.52094 5.32275L6.45614 5.86269C6.61364 5.71417 6.79258 5.58813 6.98781 5.4897L6.69199 4.38567C6.62052 4.11894 6.77881 3.84477 7.04554 3.7733C7.31227 3.70183 7.58644 3.86012 7.65791 4.12686L7.95896 5.25036C7.97242 5.25013 7.9859 5.25001 7.99942 5.25001C8.20006 5.25001 8.39457 5.27627 8.5797 5.32554L9.48939 3.7499C9.29236 3.50183 9.22853 3.19814 9.35112 2.94705C9.53901 2.56222 10.0936 2.44668 10.5899 2.68898C11.0862 2.93128 11.3362 3.43968 11.1484 3.82451Z"
            fill={props.fill}
        />
    </svg>
);

CovidShildIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default CovidShildIcon;
