import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DisabledIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M7.99998 1.42857C7.99998 2.21755 7.36039 2.85714 6.57141 2.85714C5.78243 2.85714 5.14284 2.21755 5.14284 1.42857C5.14284 0.639593 5.78243 0 6.57141 0C7.36039 0 7.99998 0.639593 7.99998 1.42857Z"
            fill={props.fill}
        />
        <path
            d="M5.05126 10.2005C5.2601 10.0527 5.32489 9.7718 5.20186 9.54747L3.88163 7.14007C3.88049 7.13798 3.88031 7.13574 3.8814 7.13362C3.90164 7.09439 4.10797 6.69357 4.18463 6.50985C4.26528 6.31656 4.44358 5.88639 4.44358 5.88639C4.44358 5.88639 4.60665 6.09558 4.79703 6.50985C4.82026 6.5604 4.85071 6.63935 4.88725 6.73406C4.95316 6.90493 5.03887 7.1271 5.13765 7.32637C5.36767 7.86937 5.92118 8.20885 6.52221 8.19936C6.67546 8.19694 6.81014 8.19864 6.89758 8.20741C8.34177 8.35226 9.54129 9.47739 9.69879 10.9759C9.87809 12.6818 8.64051 14.2101 6.93457 14.3894C5.22863 14.5687 3.70033 13.3311 3.52103 11.6252C3.50905 11.5112 3.51183 11.2745 3.51574 11.1096C3.51821 11.0052 3.45092 10.9115 3.35074 10.8818L2.5931 10.6574C2.45833 10.6175 2.32027 10.7073 2.30576 10.8472C2.2774 11.1205 2.24337 11.5365 2.27078 11.7566C2.42579 13.2314 3.29852 14.4571 4.50543 15.1229L3.91607 15.2828C3.75706 15.326 3.64668 15.4703 3.64668 15.6351C3.64668 15.8366 3.81007 16 4.01162 16H14.7903C14.8272 16 14.8571 15.9701 14.8571 15.9331V12.4324C14.8571 12.3729 14.8007 12.3298 14.7433 12.3453L10.3575 13.5352C10.8244 12.7536 11.0515 11.8197 10.949 10.8445C10.8726 10.1174 10.6217 9.45079 10.2423 8.88202C10.4742 8.86176 10.7114 8.82782 10.7606 8.82062C10.7662 8.8198 10.7713 8.82304 10.7732 8.82833L11.8502 11.7451C11.95 12.0155 12.2394 12.1653 12.5178 12.0907C12.8096 12.0125 12.9861 11.7163 12.916 11.4225L11.9033 7.17772C11.8976 7.15399 11.8758 7.13771 11.8514 7.13907L8.41996 7.32993C8.29964 7.27494 8.17655 7.22531 8.05101 7.18129C7.9503 6.39361 7.68683 4.7246 7.17871 3.85033C6.49877 2.68043 4.85812 3.26566 3.9705 4.12084C3.12837 4.9322 2.34585 7.24682 2.26786 7.4819C2.26354 7.49493 2.2667 7.50767 2.27534 7.51834L4.36897 10.1062C4.53596 10.3127 4.83454 10.3539 5.05126 10.2005Z"
            fill={props.fill}
        />
    </svg>
);

DisabledIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default DisabledIcon;
