import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DislikeFilledIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M7.33593 15.82C5.99993 15.888 5.07393 14.359 5.07393 13.067C5.07393 12.206 5.13293 11.019 5.24993 9.505H2.08093C0.731928 9.505 0.0759277 8.931 0.0759277 7.64C0.0759277 7.108 0.237928 6.524 0.560928 5.887C0.550024 5.75322 0.542688 5.61918 0.538928 5.485C0.521928 4.993 0.391928 4.42301 0.721928 3.765C1.07293 3.061 1.61193 2.729 1.90993 2.328C1.96723 2.24975 2.0364 2.18092 2.11493 2.124C2.13093 1.929 2.15593 1.781 2.19293 1.682C2.42193 1.052 2.94793 0.00500488 4.49593 0.00500488H7.55893C10.3579 0.00500488 11.0039 0.651005 10.9999 2.589V8.005C9.15993 9.11 8.68193 10.932 8.34993 12.655C7.93793 14.795 8.33193 15.769 7.33593 15.82ZM13.9999 8.005H12.9999C12.7347 8.005 12.4804 7.89965 12.2928 7.71211C12.1053 7.52458 11.9999 7.27022 11.9999 7.005V1.005C11.9999 0.739788 12.1053 0.485434 12.2928 0.297898C12.4804 0.110362 12.7347 0.00500488 12.9999 0.00500488H13.9999C14.2651 0.00500488 14.5195 0.110362 14.707 0.297898C14.8946 0.485434 14.9999 0.739788 14.9999 1.005V7.005C14.9999 7.27022 14.8946 7.52458 14.707 7.71211C14.5195 7.89965 14.2651 8.005 13.9999 8.005Z"
            fill={props.fill}
        />
    </svg>
);

DislikeFilledIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default DislikeFilledIcon;
