import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DislikeOutlineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M4.61793 10.5301H2.78993C1.02793 10.5301 0.00292969 9.59305 0.00292969 7.87805C0.00292969 7.34105 0.0819297 6.99105 0.26293 6.53405L0.31693 6.40105C0.37393 6.25705 0.40493 6.16405 0.43193 6.05105C0.44393 6.00105 0.44293 5.91505 0.42193 5.64105C0.36593 4.88605 0.40693 4.43105 0.70393 3.83605C0.87593 3.49305 1.08493 3.20705 1.35293 2.92205C1.41293 2.85705 1.54593 2.72505 1.65493 2.61505L1.81893 2.45105C1.86302 2.40908 1.90075 2.36091 1.93093 2.30805C2.08793 1.88405 2.18993 1.66205 2.42593 1.34205C2.99893 0.564052 3.89993 0.102052 5.12993 0.102052H8.31293C9.15293 0.102052 9.83293 0.248052 10.3669 0.519052C10.6419 0.203052 11.0469 0.00305176 11.4989 0.00305176H14.4989C14.8968 0.00305176 15.2783 0.161087 15.5596 0.442392C15.8409 0.723696 15.9989 1.10523 15.9989 1.50305V7.00305C15.9989 7.40088 15.8409 7.78241 15.5596 8.06371C15.2783 8.34502 14.8968 8.50305 14.4989 8.50305H11.4989C11.3889 8.50305 11.2809 8.49105 11.1769 8.46805C10.5069 9.11805 9.74493 10.6351 9.49393 11.9381C9.43659 12.2403 9.3879 12.5441 9.34793 12.8491C9.32293 13.0341 9.25193 13.6091 9.24693 13.6511V13.6531C9.04693 15.2121 8.70893 15.9031 7.49893 15.9031C5.99793 15.9031 4.47893 14.3551 4.47893 12.7131C4.47893 12.0961 4.52493 11.3691 4.61693 10.5311L4.61793 10.5301ZM13.9999 2.00405V6.50405H11.9999V2.00405H13.9999ZM7.56493 12.6091C7.53693 12.8131 7.46093 13.4331 7.46193 13.4251C7.42193 13.7421 7.38593 13.9511 7.35193 14.0841C6.86993 13.9641 6.27893 13.3061 6.27893 12.7131C6.27893 11.9501 6.36193 10.9621 6.52893 9.75305C6.54635 9.62572 6.5363 9.49613 6.49945 9.373C6.4626 9.24988 6.39981 9.13607 6.3153 9.03924C6.23078 8.94242 6.12651 8.86481 6.0095 8.81165C5.89249 8.75849 5.76545 8.73101 5.63693 8.73105H2.78993C1.98793 8.73105 1.80293 8.56105 1.80293 7.87805C1.80293 7.59205 1.83293 7.45805 1.93593 7.19805L1.98993 7.06405C2.07593 6.84705 2.13293 6.67805 2.18293 6.46805C2.25393 6.16805 2.25293 5.97705 2.21793 5.50605C2.18293 5.05005 2.19993 4.87005 2.31393 4.64105C2.39993 4.46905 2.50993 4.32005 2.66693 4.15205C2.69793 4.11805 2.78393 4.03205 2.87393 3.94205C2.97993 3.83705 3.09193 3.72505 3.13693 3.67605C3.35993 3.43605 3.51593 3.21105 3.61893 2.93305C3.71893 2.66105 3.76893 2.55305 3.87493 2.41005C4.11093 2.09005 4.47493 1.90305 5.13093 1.90305H8.31393C9.74393 1.90305 10.0969 2.31805 10.0969 3.42905V7.02405C9.02293 7.96405 8.05693 9.88405 7.72693 11.5971C7.66493 11.9261 7.61293 12.2491 7.56493 12.6091Z"
            fill={props.fill}
        />
    </svg>
);

DislikeOutlineIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default DislikeOutlineIcon;
